PROCEDURE GetPtOnPoly;

VAR
	Obj : HANDLE;
	Path : HANDLE;
	TheDist : REAL;
	OrigX, OrigY : REAL;
	Pt, Tangent : VECTOR;
	PointX, PointY : REAL;
	RunningDist : REAL;
	
	OK : BOOLEAN;
	
BEGIN
	Obj := FSActLayer;
	RunningDist := 0;
	GetSymLoc(Obj, OrigX, OrigY);
	Path := GetCustomObjectPath(Obj);
	TheDist := DistDialog('Input distance to mark', '0');
	WHILE (NOT DidCancel) DO
		BEGIN
			RunningDist := RunningDist + TheDist;
			OK := PointAlongPoly(Path, RunningDist, Pt, Tangent);
			PointX := Pt.x + OrigX;
			PointY := Pt.y + OrigY;
			Oval(PointX - 12, PointY + 12, PointX + 12, PointY - 12);
			Locus(PointX, PointY);
			TheDist := DistDialog('Input distance to mark', '0');
		END;

END;
RUN(GetPtOnPoly);

